// Get DOM elements
const ghostToggle = document.getElementById("ghostToggle");
const spookyToggle = document.getElementById("spookyToggle");
const floatToggle = document.getElementById("floatToggle");
const ghostHouse = document.getElementById("ghostHouse");
const floatingGhosts = document.querySelectorAll(".ghost");

// Toggle ghost house background
ghostToggle.addEventListener("change", function () {
  if (this.checked) {
    ghostHouse.classList.add("active");
  } else {
    ghostHouse.classList.remove("active");
  }
});

// Toggle floating ghosts
floatToggle.addEventListener("change", function () {
  if (this.checked) {
    floatingGhosts.forEach((ghost) => {
      ghost.classList.add("show");
    });
  } else {
    floatingGhosts.forEach((ghost) => {
      ghost.classList.remove("show");
    });
  }
});

// Spooky sounds effect
spookyToggle.addEventListener("change", function () {
  if (this.checked) {
    // Create a spooky sound using the Web Audio API
    try {
      const audioContext = new (window.AudioContext ||
        window.webkitAudioContext)();
      const oscillator = audioContext.createOscillator();
      const gainNode = audioContext.createGain();

      oscillator.connect(gainNode);
      gainNode.connect(audioContext.destination);

      oscillator.type = "sine";
      oscillator.frequency.setValueAtTime(200, audioContext.currentTime);
      oscillator.frequency.exponentialRampToValueAtTime(
        50,
        audioContext.currentTime + 1.5
      );

      gainNode.gain.setValueAtTime(0.1, audioContext.currentTime);
      gainNode.gain.exponentialRampToValueAtTime(
        0.01,
        audioContext.currentTime + 1.5
      );

      oscillator.start(audioContext.currentTime);
      oscillator.stop(audioContext.currentTime + 1.5);
    } catch (e) {
      console.log("Web Audio API not supported");
    }
  }
});

// Add click effects to all toggles
document.querySelectorAll(".toggle-wrapper").forEach((wrapper) => {
  wrapper.addEventListener("click", function () {
    // Add a subtle ripple effect
    const ripple = document.createElement("span");
    ripple.style.cssText = `
                    position: absolute;
                    border-radius: 50%;
                    background: rgba(255, 255, 255, 0.5);
                    transform: scale(0);
                    animation: ripple 0.6s linear;
                    z-index: 1;
                `;

    const size = Math.max(this.clientWidth, this.clientHeight);
    const rect = this.getBoundingClientRect();

    ripple.style.width = ripple.style.height = size + "px";
    ripple.style.left = event.clientX - rect.left - size / 2 + "px";
    ripple.style.top = event.clientY - rect.top - size / 2 + "px";

    this.appendChild(ripple);

    setTimeout(() => {
      ripple.remove();
    }, 600);
  });
});

// Add CSS for ripple animation
const style = document.createElement("style");
style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
        `;
document.head.appendChild(style);
